/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.grant.kerberos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.ResponseHeader;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSUtil;

public class KerberosGrant
extends AbstractAuthorizationGrantHandler {
    private static final Log log = LogFactory.getLog(KerberosGrant.class);
    private static GSSManager gssManager = GSSManager.getInstance();

    private static Oid getOid(byte[] gssToken) throws IOException, GSSException {
        GSSHeader header = new GSSHeader(new ByteArrayInputStream(gssToken, 0, gssToken.length));
        return GSSUtil.createOid(header.getOid().toString());
    }

    public boolean validateGrant(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) throws IdentityOAuth2Exception {
        String kerberosUsersId;
        block28: {
            RequestParameter[] parameters;
            String kerberosServiceToken = null;
            String kerberosRealm = null;
            kerberosUsersId = null;
            String kerberosSPN = null;
            String kerberosPwd = null;
            String userstoreDomains = null;
            FederatedAuthenticatorConfig kerberosFederatedConfig = null;
            String tenantDomain = oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getTenantDomain();
            if (StringUtils.isEmpty((String)tenantDomain)) {
                tenantDomain = "carbon.super";
            }
            for (RequestParameter requestParameter : parameters = oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getRequestParameters()) {
                if ("kerberos_token".equals(requestParameter.getKey()) && requestParameter.getValue() != null && requestParameter.getValue().length > 0 && StringUtils.isEmpty((String)(kerberosServiceToken = requestParameter.getValue()[0]))) {
                    this.handleException("Kerberos service token cannot be empty.");
                }
                if (!"kerberos_realm".equals(requestParameter.getKey()) || requestParameter.getValue() == null || requestParameter.getValue().length <= 0 || !StringUtils.isEmpty((String)(kerberosRealm = requestParameter.getValue()[0]))) continue;
                this.handleException("Kerberos realm cannot be empty.");
            }
            try {
                IdentityProvider identityProvider = IdentityProviderManager.getInstance().getIdPByName(kerberosRealm, tenantDomain);
                if (identityProvider != null) {
                    kerberosFederatedConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"IWAKerberosAuthenticator");
                    if (kerberosFederatedConfig != null) {
                        for (RequestParameter requestParameter : kerberosFederatedConfig.getProperties()) {
                            if ("SPNName".equals(requestParameter.getName())) {
                                kerberosSPN = requestParameter.getValue();
                                continue;
                            }
                            if ("SPNPassword".equals(requestParameter.getName())) {
                                kerberosPwd = requestParameter.getValue();
                                continue;
                            }
                            if (!"UserStoreDomains".equals(requestParameter.getName())) continue;
                            userstoreDomains = requestParameter.getValue();
                        }
                        if (StringUtils.isEmpty(kerberosSPN) || StringUtils.isEmpty(kerberosPwd)) {
                            this.handleException("Kerberos username/password is not provided for the IDP : " + kerberosRealm);
                        }
                    } else {
                        this.handleException("Kerberos IDP configuration could not be located : " + kerberosRealm);
                    }
                } else {
                    this.handleException("No Registered IDP found for Kerberos with realm : " + kerberosRealm);
                }
                Oid oidOfToken = GSSUtil.GSS_SPNEGO_MECH_OID;
                try {
                    oidOfToken = KerberosGrant.getOid(Base64.decode((String)kerberosServiceToken));
                }
                catch (IOException | GSSException e) {
                    log.warn((Object)("Unable to get Oid. Setting to default type SPENGO " + e.getMessage()));
                }
                GSSCredential gssCredential = null;
                try {
                    gssCredential = this.createCredentials(kerberosSPN, kerberosPwd.toCharArray(), oidOfToken);
                }
                catch (PrivilegedActionException | LoginException e) {
                    log.error((Object)e);
                }
                if (gssCredential != null) {
                    try {
                        kerberosUsersId = this.validateKerberosTicket(gssCredential, Base64.decode((String)kerberosServiceToken));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Kerberos token validated successfully");
                        }
                    }
                    catch (GSSException e) {
                        log.error((Object)e);
                    }
                }
                if (kerberosUsersId != null) {
                    int indexOfAt = kerberosUsersId.lastIndexOf(64) != -1 ? kerberosUsersId.lastIndexOf(64) : kerberosUsersId.length();
                    AuthenticatedUser authenticatedUser = new AuthenticatedUser();
                    String username = kerberosUsersId.substring(0, indexOfAt);
                    authenticatedUser.setUserName(username);
                    if (StringUtils.isNotEmpty((String)userstoreDomains)) {
                        String[] userStores;
                        for (String userStoreDomain : userStores = userstoreDomains.split(",")) {
                            if (this.isUserExistsInUserStore(authenticatedUser.getUserName(), tenantDomain, userStoreDomain)) {
                                authenticatedUser.setUserStoreDomain(userStoreDomain);
                                break;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("User: " + authenticatedUser.getUserName() + " does not exist in given user store domains: " + userstoreDomains));
                        }
                    } else {
                        authenticatedUser.setFederatedUser(true);
                    }
                    authenticatedUser.setTenantDomain(oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getTenantDomain());
                    oAuthTokenReqMessageContext.setAuthorizedUser(authenticatedUser);
                    oAuthTokenReqMessageContext.setScope(oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getScope());
                    oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().setResourceOwnerUsername(kerberosUsersId);
                    break block28;
                }
                ResponseHeader responseHeader = new ResponseHeader();
                responseHeader.setKey("OAuth2 Token Request");
                responseHeader.setValue("Provided Kerberos token is Invalid.");
                oAuthTokenReqMessageContext.addProperty((Object)"RESPONSE_HEADERS", (Object)new ResponseHeader[]{responseHeader});
            }
            catch (IdentityProviderManagementException e) {
                this.handleException("Error while getting the Federated Identity Provider ");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Issuing OAuth2 token by kerberos-oauth2 grant");
        }
        return kerberosUsersId != null;
    }

    private GSSCredential createCredentials(String spnUsername, char[] spnPassword, final Oid oid) throws LoginException, PrivilegedActionException {
        CallbackHandler callbackHandler = this.getUserNamePasswordCallbackHandler(spnUsername, spnPassword);
        LoginContext loginContext = new LoginContext("Server", callbackHandler);
        loginContext.login();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre-authentication successful for with Kerberos Server.");
        }
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return gssManager.createCredential(null, Integer.MAX_VALUE, oid, 2);
            }
        };
        if (log.isDebugEnabled()) {
            Set<Principal> principals = loginContext.getSubject().getPrincipals();
            String principalName = null;
            if (principals != null) {
                principalName = principals.toString();
            }
            log.debug((Object)("Creating gss credentials as principal : " + principalName));
        }
        return Subject.doAs(loginContext.getSubject(), action);
    }

    private CallbackHandler getUserNamePasswordCallbackHandler(final String username, final char[] password) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callback) {
                for (Callback currentCallBack : callback) {
                    if (currentCallBack instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)currentCallBack;
                        nameCallback.setName(username);
                        continue;
                    }
                    if (currentCallBack instanceof PasswordCallback) {
                        PasswordCallback passCallback = (PasswordCallback)currentCallBack;
                        passCallback.setPassword(password);
                        continue;
                    }
                    log.error((Object)("Unsupported Callback class = " + currentCallBack.getClass().getName()));
                }
            }
        };
    }

    private String validateKerberosTicket(GSSCredential gssCredentials, byte[] gssToken) throws GSSException {
        GSSContext context = gssManager.createContext(gssCredentials);
        context.acceptSecContext(gssToken, 0, gssToken.length);
        if (!context.isEstablished()) {
            log.error((Object)"Unable to decrypt the kerberos ticket as context was not established.");
            return null;
        }
        String initiator = context.getSrcName().toString();
        if (log.isDebugEnabled()) {
            String msg = "Extracted details from GSS Token, Initiator : " + initiator + " , Intended target : " + context.getTargName().toString();
            log.debug((Object)msg);
        }
        return initiator;
    }

    private void handleException(String errorMessage) throws IdentityOAuth2Exception {
        log.error((Object)errorMessage);
        throw new IdentityOAuth2Exception(errorMessage);
    }

    private void handleException(String errorMessage, Exception e) throws IdentityOAuth2Exception {
        log.error((Object)errorMessage, (Throwable)e);
        throw new IdentityOAuth2Exception(errorMessage, (Throwable)e);
    }

    private boolean isUserExistsInUserStore(String username, String tenantDomain, String userStoreDomain) throws IdentityOAuth2Exception {
        try {
            String userNameWithUserStoreDomain = IdentityUtil.addDomainToName((String)username, (String)userStoreDomain);
            RealmService realmService = IdentityTenantUtil.getRealmService();
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            UserStoreManager userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            return userStoreManager.isExistingUser(userNameWithUserStoreDomain);
        }
        catch (UserStoreException e) {
            String errorMsg = "Error when searching for user: %s in '%s' userStoreDomain in '%s' tenant.";
            this.handleException(String.format(errorMsg, username, userStoreDomain, tenantDomain), (Exception)((Object)e));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMsg = "Error while retrieving userStoreManger for tenant: %s.";
            this.handleException(String.format(errorMsg, tenantDomain), (Exception)((Object)e));
        }
        return false;
    }
}

